# Work Session Tracker Chrome Extension

A generic Chrome extension that collects anonymized browser activity snapshots and sends them to a backend server for intent inference.

## Features

- **Activity Tracking**: Captures URL, Page Title, and Entity ID (via meta tag or logic).
- **Action Logging**: generic logging of Clicks, Form Submits, and Input Changes.
- **Privacy Focused**:
  - No raw input text capture (except submitting button labels).
  - PII redaction for labels.
  - Client ID distinction without user identity.
- **Configurable**: Set your own backend URL and snapshot interval.

## Installation

1. Clone or download this repository.
2. Open Chrome and navigate to `chrome://extensions/`.
3. Enable **Developer mode** (top right).
4. Click **Load unpacked**.
5. Select the directory containing this project (`/Users/mosherecanati/dev/intentTracker`).

## Configuration

1. Click the extension icon (puzzle piece) and pin "Work Session Tracker".
2. Right-click the icon and select **Options**.
3. Configure:
   - **Backend Server URL**: The endpoint for POST requests.
   - **Snapshot Interval**: How often (in minutes) to send data.
   - **Enable Tracking**: Toggle on/off.

## Data Format

The extension sends a JSON payload via POST to the configured URL:

```json
{
  "client_id": "uuid-v4-string",
  "timestamp": "2023-10-27T10:00:00.000Z",
  "tab_id": 123,
  "url": "https://example.com/task/1",
  "page_title": "Task 1 - Project Management",
  "entity_id": "task-1",
  "recent_actions": [
    {
      "event_type": "click",
      "tag_name": "BUTTON",
      "input_type": null,
      "role": "button",
      "label": "Save Changes",
      "selector": "button.save-btn",
      "timestamp": "2023-10-27T09:59:55.000Z"
    }
  ]
}
```

## Backend Server Setup

The project includes a Node.js backend server in the `server` directory.

### Prerequisites

- Node.js (v18+)
- An OpenAI API Key

### Installation & Running

1. Navigate to the server directory:
   ```bash
   cd server
   ```
2. Install dependencies:
   ```bash
   npm install
   ```
3. Create a `.env` file based on the example:
   ```bash
   cp .env.example .env
   ```
4. Open `.env` and add your `OPENAI_API_KEY`.
5. Start the server:
   ```bash
   npm start
   ```

The server will listen on `http://localhost:3000`. 
Ensure your extension Options are configured to point to `http://localhost:3000/api/snapshot` (or your ngrok URL if testing remotely).

## Backend Integration


Your backend server should:
1. Accept POST requests at the configured URL.
2. Anonymize/Aggregate data into sessions.
3. Use an LLM (e.g., ChatGPT) to infer "intent" based on recent actions and page context.
4. Store the resulting `work_session`.
