/**
 * Work Session Tracker - Options Logic
 */

// Saves options to chrome.storage
function saveOptions() {
    const serverUrl = document.getElementById('serverUrl').value;
    const interval = parseInt(document.getElementById('snapshotIntervalMinutes').value, 10);
    const enabled = document.getElementById('enabled').checked;

    // Narma fields
    const narmaOrgId = document.getElementById('narmaOrgId').value;
    const roleId = document.getElementById('roleId').value;
    const orgUnitId = document.getElementById('orgUnitId').value;

    chrome.storage.sync.set({
        serverUrl: serverUrl,
        snapshotIntervalMinutes: interval,
        enabled: enabled,
        narmaOrgId: narmaOrgId,
        roleId: roleId,
        orgUnitId: orgUnitId
    }, () => {
        // Update status to let user know options were saved.
        const status = document.getElementById('status');
        status.textContent = 'Options saved.';
        setTimeout(() => {
            status.textContent = '';
        }, 2000);
    });
}

// Restores select box and checkbox state using the preferences
// stored in chrome.storage.
function restoreOptions() {
    chrome.storage.sync.get({
        serverUrl: 'http://localhost:3000/api/snapshot',
        snapshotIntervalMinutes: 1,
        enabled: true,
        narmaOrgId: '',
        roleId: '',
        orgUnitId: ''
    }, (items) => {
        document.getElementById('serverUrl').value = items.serverUrl;
        document.getElementById('snapshotIntervalMinutes').value = items.snapshotIntervalMinutes;
        document.getElementById('enabled').checked = items.enabled;

        document.getElementById('narmaOrgId').value = items.narmaOrgId;
        document.getElementById('roleId').value = items.roleId;
        document.getElementById('orgUnitId').value = items.orgUnitId;
    });
}

const showStatus = (msg, color) => {
    const status = document.getElementById('status');
    status.textContent = msg;
    status.style.color = color || 'green';
    setTimeout(() => {
        status.textContent = '';
    }, 3000);
};

document.addEventListener('DOMContentLoaded', restoreOptions);
document.getElementById('save').addEventListener('click', saveOptions);
